
import gurobipy as gp

# Create a new model
model = gp.Model("GiftWrapping")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="small_gifts") # Number of small gifts
y = model.addVar(vtype=gp.GRB.INTEGER, name="large_gifts") # Number of large gifts

# Set objective function
model.setObjective(3*x + 5*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 15*y <= 720, "worker_time")
model.addConstr(2*x + 3*y <= 150, "wrapping_paper")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of small gifts to wrap: {x.x}")
    print(f"Number of large gifts to wrap: {y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

