
from gurobipy import *

# Create a new model
m = Model("GiftWrapping")

# Define variables
S = m.addVar(vtype=GRB.INTEGER, name="SmallGifts")
L = m.addVar(vtype=GRB.INTEGER, name="LargeGifts")

# Objective function: Maximize profit
m.setObjective(3*S + 5*L, GRB.MAXIMIZE)

# Constraints
m.addConstr(10*S + 15*L <= 720, "TimeConstraint")
m.addConstr(2*S + 3*L <= 150, "PaperConstraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Small Gifts: {S.x}")
    print(f"Large Gifts: {L.x}")
    print(f"Total Profit: ${3*S.x + 5*L.x:.2f}")
else:
    print("No optimal solution found. The model is likely infeasible.")

