
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, name="small_gifts")
y = m.addVar(lb=0, name="large_gifts")

# Define the objective function
m.setObjective(3*x + 5*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
worker_time_constraint = m.addConstr(10*x + 15*y <= 720, name="worker_time")
wrapping_paper_constraint = m.addConstr(2*x + 3*y <= 150, name="wrapping_paper")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of small gifts: {x.varValue}")
    print(f"Number of large gifts: {y.varValue}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
