
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(name="oats") # Acres of oats
y = m.addVar(name="flaxseed") # Acres of flaxseed

# Set objective function
m.setObjective(500*x + 400*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50, "land_constraint")
m.addConstr(x >= 5, "min_oats")
m.addConstr(y >= 8, "min_flaxseed")
m.addConstr(x <= 2*y, "oats_flaxseed_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of oats")
    print(f"Plant {y.x} acres of flaxseed")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

