
from gurobipy import *

# Create a new model
m = Model("Farmer_Optimization")

# Define variables
O = m.addVar(vtype=GRB.CONTINUOUS, name="oats", lb=0)
F = m.addVar(vtype=GRB.CONTINUOUS, name="flaxseed", lb=0)

# Set the objective function to maximize profit
m.setObjective(500*O + 400*F, GRB.MAXIMIZE)

# Add constraints
m.addConstr(O + F <= 50, "total_land")
m.addConstr(O >= 5, "min_oats")
m.addConstr(F >= 8, "min_flaxseed")
m.addConstr(O <= 2*F, "oats_vs_flaxseed")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oats: {O.x} acres")
    print(f"Flaxseed: {F.x} acres")
    print(f"Maximum Profit: ${500*O.x + 400*F.x}")
else:
    print("No optimal solution found.")
