
import gurobi

def solve_farmer_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="oats")  # Acres of oats
    x2 = model.addVar(lb=0, name="flaxseed")  # Acres of flaxseed

    # Objective: Maximize profit
    model.setObjective(500 * x1 + 400 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 5, name="min_oats")
    model.addConstr(x2 >= 8, name="min_flaxseed")
    model.addConstr(x1 <= 2 * x2, name="oats_vs_flaxseed")
    model.addConstr(x1 + x2 <= 50, name="total_land")

    # Update model
    model.update()

    # Solve model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of oats: {x1.varValue}")
        print(f"Optimal acres of flaxseed: {x2.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_farmer_problem()
