
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("AminoAcids")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="orange_juice")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_juice")

# Set objective function
m.setObjective(7*x + y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 5*y >= 30, "Lysine")
m.addConstr(3*x + 5*y >= 40, "Alanine")
m.addConstr(5*x + 2*y <= 50, "Methionine")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Orange Juice: {x.x}")
    print(f"  Apple Juice: {y.x}")
    print(f"  Minimum Glycine: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

