
from gurobipy import *

# Create a model
m = Model("Cindy_Juice")

# Define variables
orange_juice = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="orange_juice")
apple_juice = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_juice")

# Add constraints
m.addConstr(2*orange_juice + 5*apple_juice >= 30, "lysine_constraint")
m.addConstr(3*orange_juice + 5*apple_juice >= 40, "alanine_constraint")
m.addConstr(5*orange_juice + 2*apple_juice <= 50, "methionine_constraint")

# Set objective function
m.setObjective(7*orange_juice + apple_juice, GRB.MINIMIZE)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Orange juice: {orange_juice.x}")
    print(f"Apple juice: {apple_juice.x}")
    print(f"Glycine intake: {7*orange_juice.x + apple_juice.x}")
else:
    print("No optimal solution found.")
