
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(lb=0, name="orange_juice")  # glasses of orange juice
    y = model.addVar(lb=0, name="apple_juice")  # glasses of apple juice

    # Define the constraints
    model.addConstr(2*x + 5*y >= 30, name="lysine_constraint")
    model.addConstr(3*x + 5*y >= 40, name="alanine_constraint")
    model.addConstr(5*x + 2*y <= 50, name="methionine_constraint")

    # Define the objective function
    model.setObjective(7*x + y, gurobi.GRB.MINIMIZE)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum Glycine: {7*x.varValue + y.varValue}")
    else:
        print("No optimal solution found")

# Run the optimization problem
solve_optimization_problem()
