
from gurobipy import Model, GRB

# Create a new model
m = Model("Potato Transportation")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="trucks") # Number of trucks
y = m.addVar(vtype=GRB.INTEGER, name="vans")   # Number of vans

# Set objective function
m.setObjective(150*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 12*y <= 250, "budget")
m.addConstr(x < y, "traffic")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of trucks (x): {x.x}")
    print(f"Number of vans (y): {y.x}")
    print(f"Maximum potatoes transported: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

