
from gurobipy import *

# Create a new model
m = Model("Potato_Transportation")

# Define the variables
T = m.addVar(vtype=GRB.INTEGER, name="Trucks")
V = m.addVar(vtype=GRB.INTEGER, name="Vans")

# Objective function: Maximize the total potatoes transported
m.setObjective(150*T + 80*V, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*T + 12*V <= 250, "Cost_Constraint")
m.addConstr(T <= V - 1, "Traffic_Law_Constraint")
m.addConstr(T >= 0, "Non_Negativity_Trucks")
m.addConstr(V >= 0, "Non_Negativity_Vans")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Trucks: {T.x}")
    print(f"Number of Vans: {V.x}")
    print(f"Total Potatoes Transported: {150*T.x + 80*V.x}")
else:
    print("No optimal solution found.")
