
import gurobi

def solve_potato_transportation():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    T = model.addVar(lb=0, name="Trucks")  # Number of trucks
    V = model.addVar(lb=0, name="Vans")   # Number of vans

    # Objective function: Maximize the number of potatoes transported
    model.setObjective(150*T + 80*V, gurobi.GRB.MAXIMIZE)

    # Cost constraint: 20T + 12V <= 250
    model.addConstr(20*T + 12*V <= 250, name="Cost_Constraint")

    # Traffic law constraint: T < V
    model.addConstr(T <= V - 1, name="Traffic_Law_Constraint")  # Adjusted for integer solution

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Trucks = {T.varValue}, Vans = {V.varValue}")
        print(f"Max Potatoes Transported: {150*T.varValue + 80*V.varValue}")
    else:
        print("The model is infeasible.")

solve_potato_transportation()
