
import gurobipy as gp

# Create a new model
m = gp.Model("Orange Transportation")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="train_trips") # Integer number of train trips
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="car_trips")   # Integer number of car trips

# Set objective function
m.setObjective(500*x + 200*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 30*y <= 500, "budget")
m.addConstr(x <= y, "train_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of oranges transported: {m.objVal}")
    print(f"Number of train trips: {x.x}")
    print(f"Number of car trips: {y.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

