
from gurobipy import *

# Create a model
m = Model("Orange Farm Optimization")

# Define decision variables
t = m.addVar(vtype=GRB.INTEGER, name="train_trips")
c = m.addVar(vtype=GRB.INTEGER, name="car_trips")

# Objective function: Maximize the total number of oranges sent
m.setObjective(500*t + 200*c, GRB.MAXIMIZE)

# Budget constraint
m.addConstr(50*t + 30*c <= 500, "budget_constraint")

# Scheduling issue constraint
m.addConstr(t <= c, "scheduling_issue_constraint")

# Non-negativity constraints (implicitly handled by addVar for integer variables)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of train trips: {t.x}")
    print(f"Number of car trips: {c.x}")
    print(f"Total oranges sent: {500*t.x + 200*c.x}")
else:
    print("No optimal solution found. The problem might be infeasible.")
