
import gurobi

def solve_orange_farm_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    T = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Train Trips")
    C = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Car Trips")

    # Objective function: Maximize the number of oranges sent
    model.setObjective(500*T + 200*C, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(50*T + 30*C <= 500, name="Budget Constraint")

    # Train trips cannot exceed car trips
    model.addConstr(T <= C, name="Train Car Trips Constraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal Solution: Train Trips = {T.varValue}, Car Trips = {C.varValue}")
        print(f"Maximum Oranges Sent: {500*T.varValue + 200*C.varValue}")
    else:
        print("The model is infeasible")

solve_orange_farm_problem()
