
import gurobipy as gp

# Create a new model
model = gp.Model("sign_shop")

# Create decision variables
x = model.addVar(lb=0, name="storefront_signs")
y = model.addVar(lb=0, name="street_signs")

# Set objective function
model.setObjective(400*x + 120*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + y <= 100, "cutting")
model.addConstr(x + 0.5*y <= 50, "printing")
model.addConstr(2*x + 0.8*y <= 60, "assembly")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of storefront signs: {x.x}")
    print(f"Number of street signs: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

