
from gurobipy import *

# Create a new model
m = Model("Sign_Shop_Optimization")

# Define the decision variables
x_s = m.addVar(vtype=GRB.CONTINUOUS, name="storefront_signs", lb=0)
x_t = m.addVar(vtype=GRB.CONTINUOUS, name="street_signs", lb=0)

# Set the objective function
m.setObjective(400*x_s + 120*x_t, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x_s + x_t <= 100, name="cutting_time")
m.addConstr(x_s + 0.5*x_t <= 50, name="printing_time")
m.addConstr(2*x_s + 0.8*x_t <= 60, name="assembly_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of storefront signs: {x_s.x}")
    print(f"Number of street signs: {x_t.x}")
    print(f"Maximum profit: ${400*x_s.x + 120*x_t.x:.2f}")
else:
    print("No optimal solution found.")
