
import gurobipy as gp

# Create a new model
m = gp.Model("Sign_Shop")

# Define the decision variables
x1 = m.addVar(name="storefront_signs", lb=0, ub=None, obj=400)
x2 = m.addVar(name="street_signs", lb=0, ub=None, obj=120)

# Define the constraints
m.addConstr(2*x1 + x2 <= 100, name="cutting_time")
m.addConstr(x1 + 0.5*x2 <= 50, name="printing_time")
m.addConstr(2*x1 + 0.8*x2 <= 60, name="assembly_time")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GUROBI_OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of storefront signs: {x1.varValue}")
    print(f"Number of street signs: {x2.varValue}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
