
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bike_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="road_bikes")  # Road bikes
y = m.addVar(vtype=GRB.CONTINUOUS, name="mountain_bikes")  # Mountain bikes

# Set objective function
m.setObjective(70*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 5*y <= 12, "grinder_constraint")
m.addConstr(2*x + 2.5*y <= 12, "polisher_constraint")
m.addConstr(x >= 0, "road_bikes_non_negative")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "mountain_bikes_non_negative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Road bikes: {x.x:.2f}")
    print(f"Mountain bikes: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

