
from gurobipy import *

# Create a new model
m = Model("Bike_Factory")

# Decision Variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="Road_Bikes", lb=0)
M = m.addVar(vtype=GRB.CONTINUOUS, name="Mountain_Bikes", lb=0)

# Objective Function: Maximize profit
m.setObjective(70*R + 100*M, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*R + 5*M <= 12, "Grinder_Constraint")
m.addConstr(2*R + 2.5*M <= 12, "Polisher_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Road Bikes: {R.x}")
    print(f"Number of Mountain Bikes: {M.x}")
    print(f"Maximum Profit: ${70*R.x + 100*M.x:.2f}")
else:
    print("No optimal solution found")
