
import gurobipy as gp

# Create a new model
model = gp.Model("BikeFactory")

# Define the decision variables
R = model.addVar(lb=0, name="Road_Bikes")
M = model.addVar(lb=0, name="Mountain_Bikes")

# Define the objective function
model.setObjective(70*R + 100*M, gp.GRB.MAXIMIZE)

# Add the grinder and polisher constraints
model.addConstr(3*R + 5*M <= 12, name="Grinder_Constraint")
model.addConstr(2*R + 2.5*M <= 12, name="Polisher_Constraint")

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Road Bikes: {R.varValue}")
    print(f"Mountain Bikes: {M.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
