
import gurobipy as gp

# Create a new model
model = gp.Model("DonutProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chocolate_donuts")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="maple_donuts")

# Set objective function
model.setObjective(2*x + 3*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 50, "demand_chocolate")
model.addConstr(y >= 75, "demand_maple")
model.addConstr(x <= 100, "capacity_chocolate")
model.addConstr(y <= 150, "capacity_maple")
model.addConstr(x + y >= 200, "total_production")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of chocolate donuts: {x.x}")
    print(f"Number of maple donuts: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

