
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Decision variables
x = m.addVar(lb=50, ub=100, name="Chocolate_Donuts")  # At least 50, at most 100 chocolate donuts
y = m.addVar(lb=75, ub=150, name="Maple_Donuts")      # At least 75, at most 150 maple donuts

# Objective function: Maximize profit
m.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Additional constraint for total donuts
m.addConstr(x + y >= 200, name="Total_Donuts")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Chocolate Donuts: {x.x}")
    print(f"Number of Maple Donuts: {y.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found. The model is likely infeasible.")

