
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=50, ub=100, name="chocolate_donuts")
    y = model.addVar(lb=75, ub=150, name="maple_donuts")

    # Objective function: maximize profit
    model.setObjective(2*x + 3*y, gurobi.GRB.MAXIMIZE)

    # Contract constraint: at least 200 donuts
    model.addConstraint(x + y >= 200, name="total_donuts")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${2*x.varValue + 3*y.varValue}")
    else:
        print("The model is infeasible.")

solve_bakery_problem()
