
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("RefrigeratorProduction")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_refrigerators")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="energy_efficient_refrigerators")

# Set objective function
m.setObjective(50*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 25, "demand_regular")
m.addConstr(y >= 40, "demand_energy_efficient")
m.addConstr(x <= 100, "capacity_regular")
m.addConstr(y <= 70, "capacity_energy_efficient")
m.addConstr(x + y >= 90, "total_production")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular refrigerators: {x.x}")
    print(f"Number of energy-efficient refrigerators: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

