
from gurobipy import *

# Create a new model
m = Model("Furniture_Company_Optimization")

# Decision variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Refrigerators", lb=0)
E = m.addVar(vtype=GRB.CONTINUOUS, name="Energy_Efficient_Refrigerators", lb=0)

# Objective function: Maximize profit
m.setObjective(50*R + 80*E, GRB.MAXIMIZE)

# Constraints
# Demand constraints
m.addConstr(R >= 25, "Min_Regular_Demand")
m.addConstr(E >= 40, "Min_Energy_Efficient_Demand")

# Production capacity constraints
m.addConstr(R <= 100, "Max_Regular_Production")
m.addConstr(E <= 70, "Max_Energy_Efficient_Production")

# Total production constraint
m.addConstr(R + E >= 90, "Min_Total_Production")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Refrigerators: {R.x}")
    print(f"Energy Efficient Refrigerators: {E.x}")
    print(f"Total Profit: ${50*R.x + 80*E.x:.2f}")
else:
    print("No optimal solution found")
