
import gurobi

def solve_refrigerator_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    R = model.addVar(lb=25, ub=100, name="Regular_Refrigerators")
    E = model.addVar(lb=40, ub=70, name="Energy_Efficient_Refrigerators")

    # Objective function: maximize profit
    model.setObjective(50*R + 80*E, gurobi.GRB.MAXIMIZE)

    # Additional constraint: total production
    model.addConstraint(R + E >= 90)

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production: Regular={R.varValue}, Energy Efficient={E.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_refrigerator_problem()
