
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("luca_investment")

# Create variables
x = m.addVar(name="fishing_investment")  # Investment in fishing
y = m.addVar(name="education_investment") # Investment in education

# Set objective function
m.setObjective(1.3 * x + 2.1 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 20000, "total_investment")
m.addConstr(y >= 5000, "min_education")
m.addConstr(x >= 0.3 * (x + y), "min_fishing")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Invest ${x.x:.2f} in fishing")
    print(f"Invest ${y.x:.2f} in education")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

