
from gurobipy import *

# Create a new model
m = Model("Luca_Investment")

# Create variables
xf = m.addVar(vtype=GRB.CONTINUOUS, name="Fishing_Industry_Investment")
xe = m.addVar(vtype=GRB.CONTINUOUS, name="Education_Industry_Investment")

# Set the objective function
m.setObjective(1.30*xf + 2.10*xe, GRB.MAXIMIZE)

# Add constraints
m.addConstr(xf + xe <= 20000, "Total_Investment_Constraint")
m.addConstr(xe >= 5000, "Minimum_Education_Investment")
m.addConstr(xf >= (3/7)*xe, "Fishing_Industry_Percentage")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Fishing Industry Investment: $", xf.x)
    print("Education Industry Investment: $", xe.x)
    print("Total Profit: $", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)

