
import gurobi

def luca_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="fishing_investment", lb=0)
    y = model.addVar(name="education_investment", lb=0)

    # Objective function: Maximize profit
    model.setObjective(1.30*x + 2.10*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 20000, name="total_investment")
    model.addConstr(y >= 5000, name="min_education_investment")
    model.addConstr(7*x - 3*y >= 0, name="fishing_investment_percentage")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Investment in fishing industry: ${x.varValue:.2f}")
        print(f"Investment in education industry: ${y.varValue:.2f}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

# Run the function
luca_investment_problem()
