
import gurobipy as gp

# Create a new model
model = gp.Model("Sign_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="LED_signs")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Neon_signs")

# Set objective function
model.setObjective(1500*x + 1450*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 3, "LED_capacity")
model.addConstr(y <= 4, "Neon_capacity")
model.addConstr(x + y <= 7, "QC_capacity")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of LED signs to produce: {x.x}")
    print(f"Number of Neon signs to produce: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

