
from gurobipy import *

# Create a new model
m = Model("Sign_Making_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="LED_Signs")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="Neon_Signs")

# Set the objective function
m.setObjective(1500*x + 1450*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x <= 3, "Team_A_Constraint")
m.addConstr(y <= 4, "Team_B_Constraint")
m.addConstr(x + y <= 7, "QC_Inspector_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"LED Signs: {x.x}")
    print(f"Neon Signs: {y.x}")
    print(f"Maximum Profit: ${1500*x.x + 1450*y.x}")
else:
    print("No optimal solution found.")
