
import gurobi

def solve_sign_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, ub=3, name="LED_signs")  # Number of LED signs
    y = model.addVar(lb=0, ub=4, name="neon_signs")  # Number of neon signs

    # Objective function: Maximize profit
    model.setObjective(1500 * x + 1450 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 7, name="QC_inspector_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: LED signs = {x.varValue}, neon signs = {y.varValue}")
        print(f"Max Profit: ${1500 * x.varValue + 1450 * y.varValue}")
    else:
        print("The model is infeasible")

solve_sign_problem()
