
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Investment_Problem")

    # Create variables
    x = m.addVar(nonnegative=True, name="fishing")
    y = m.addVar(nonnegative=True, name="transportation")

    # Set objective function
    m.setObjective(0.3 * x + 0.15 * y, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 20000, "total_investment")
    m.addConstr(x >= 8000, "min_fishing")
    m.addConstr(y >= 5000, "min_transportation")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal investment in fishing: {x.x}")
        print(f"Optimal investment in transportation: {y.x}")
        print(f"Maximum return: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
