
from gurobipy import *

# Create a new model
m = Model("Marty_Investment")

# Define variables
x = m.addVar(lb=8000, name="fishing_investment")  # At least $8,000 in fishing
y = m.addVar(lb=5000, name="transportation_investment")  # At least $5,000 in transportation

# Constraint: Total investment should not exceed $20,000
m.addConstr(x + y <= 20000, "total_budget")

# Objective function: Maximize return
m.setObjective(0.3*x + 0.15*y, GRB.MAXIMIZE)

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f" Invest ${x.x} in fishing")
    print(f" Invest ${y.x} in transportation")
    print(f" Maximum return: ${m.objVal}")
else:
    print("No optimal solution found")
