
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    F = model.addVar(lb=0, name="Fishing_Investment")
    T = model.addVar(lb=0, name="Transportation_Investment")

    # Objective function: Maximize 0.3F + 0.15T
    model.setObjective(0.3 * F + 0.15 * T, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(F + T <= 20000, name="Total_Investment")
    model.addConstr(F >= 0.4 * 20000, name="Fishing_Min_Investment")
    model.addConstr(T >= 5000, name="Transportation_Min_Investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Investment:")
        print(f"Fishing: ${F.varValue}")
        print(f"Transportation: ${T.varValue}")
        print(f"Max Return: ${0.3 * F.varValue + 0.15 * T.varValue}")
    else:
        print("The problem is infeasible.")

solve_investment_problem()
