
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("gummy_vitamins")

# Create variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="blue_gummies")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="red_gummies")

# Set objective function
model.setObjective(2*x + 3*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(3*x + 4*y >= 40, "calcium")
model.addConstr(2*x + 3*y >= 45, "vitamin_a")
model.addConstr(5*x + 2*y >= 20, "iron")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal}")
    print(f"Number of blue gummies: {x.x}")
    print(f"Number of red gummies: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

