
from gurobipy import *

# Create a new model
m = Model("Gummy_Vitamins")

# Define the decision variables
x_b = m.addVar(vtype=GRB.INTEGER, name="blue_gummies")
x_r = m.addVar(vtype=GRB.INTEGER, name="red_gummies")

# Define the objective function
m.setObjective(2*x_b + 3*x_r, GRB.MINIMIZE)

# Define the constraints
m.addConstr(3*x_b + 4*x_r >= 40, "calcium_requirement")
m.addConstr(2*x_b + 3*x_r >= 45, "vitamin_a_requirement")
m.addConstr(5*x_b + 2*x_r >= 20, "iron_requirement")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x_b.varName} = {x_b.x}, {x_r.varName} = {x_r.x}")
    print(f"Total cost: ${2*x_b.x + 3*x_r.x}")
else:
    print("No optimal solution found")
