
import gurobi

def solve_gummy_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="blue_gummies", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="red_gummies", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(2*x + 3*y, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(3*x + 4*y >= 40, name="calcium")
    model.addConstr(2*x + 3*y >= 45, name="vitamin_A")
    model.addConstr(5*x + 2*y >= 20, name="iron")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: ${2*x.varValue + 3*y.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_gummy_problem()
