
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Movie_Promotion")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="social_media_adverts")
y = m.addVar(vtype=GRB.INTEGER, name="magazine_covers")

# Set objective function
m.setObjective(100000*x + 54000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3000*x + 6000*y <= 500000, "budget_constraint")
m.addConstr(x >= 10, "min_social_media")
m.addConstr(x <= 20, "max_social_media")
m.addConstr(y >= 24, "min_magazine_covers")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Exposure: {m.objVal}")
    print(f"Number of Social Media Adverts: {x.x}")
    print(f"Number of Magazine Covers: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

