
from gurobipy import *

# Create a model
m = Model("Film_Promotion")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="Social_Media_Adverts", lb=10, ub=20)
x2 = m.addVar(vtype=GRB.INTEGER, name="Magazine_Covers", lb=24)

# Objective function: Maximize exposure
m.setObjective(100000*x1 + 54000*x2, GRB.MAXIMIZE)

# Budget constraint
m.addConstr(3000*x1 + 6000*x2 <= 500000, "Budget_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Social Media Adverts: {x1.x}")
    print(f"Magazine Covers: {x2.x}")
    print(f"Maximum Exposure: {m.ObjVal}")
else:
    print("No optimal solution found.")
