
import gurobipy as gp

# Create a new model
m = gp.Model("film_agency")

# Variables
x = m.addVar(10, 20, name="social_media_adverts")  # At least 10, at most 20
y = m.addVar(24, name="magazine_covers")  # At least 24

# Objective function: Maximize exposure
m.setObjective(100000*x + 54000*y, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(3000*x + 6000*y <= 500000, name="budget_constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of social media adverts: {x.varValue}")
    print(f"Number of magazine covers: {y.varValue}")
    print(f"Maximum exposure: {100000*x.varValue + 54000*y.varValue}")
else:
    print("No optimal solution found.")
