
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_optimization")

# Create decision variables
c = m.addVar(vtype=GRB.INTEGER, name="couches")
b = m.addVar(vtype=GRB.INTEGER, name="beds")

# Set objective function
m.setObjective(200*c + 400*b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*c + 20*b <= 300, "space_constraint")
m.addConstr(b >= 0.5*(c + b), "bed_proportion_constraint")
m.addConstr(300*c + 600*b <= 8000, "budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of couches: {c.x}")
    print(f"Number of beds: {b.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

