
from gurobipy import *

# Create a new model
m = Model("Furniture_Stocking")

# Decision variables
couches = m.addVar(vtype=GRB.INTEGER, name="couches")
beds = m.addVar(vtype=GRB.INTEGER, name="beds")

# Objective function: Maximize profit
m.setObjective(200*couches + 400*beds, GRB.MAXIMIZE)

# Constraints
m.addConstr(15*couches + 20*beds <= 300, "space_constraint")
m.addConstr(beds >= couches, "minimum_beds_percentage")
m.addConstr(300*couches + 600*beds <= 8000, "budget_constraint")
m.addConstr(couches >= 0, "non_negative_couches")
m.addConstr(beds >= 0, "non_negative_beds")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Couches: {couches.x}")
    print(f"Beds: {beds.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
