
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture_Store_Optimization")

# Decision Variables
C = model.addVar(lb=0, name="Couches")  # Number of couches
B = model.addVar(lb=0, name="Beds")    # Number of beds

# Objective Function: Maximize profit
model.setObjective(200*C + 400*B, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(15*C + 20*B <= 300, name="Space_Constraint")
model.addConstr(B >= C, name="Bed_Percentage_Constraint")
model.addConstr(300*C + 600*B <= 8000, name="Capital_Constraint")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Couches: {C.varValue}")
    print(f"Beds: {B.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
