
import gurobipy as gp

# Create a new model
m = gp.Model("ToyProduction")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="beavers") # Number of beavers, integer
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bears")   # Number of bears, integer

# Set objective function
m.setObjective(5*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 15*y <= 2000, "time_constraint")
m.addConstr(x >= 3*y, "beaver_demand")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Beavers (x): {x.x}")
    print(f"Number of Bears (y): {y.x}")
    print(f"Optimal Profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

