
from gurobipy import *

# Create a new model
model = Model("Stuffed_Animals")

# Define the decision variables
B = model.addVar(vtype=GRB.INTEGER, name="Beavers")
R = model.addVar(vtype=GRB.INTEGER, name="Bears")

# Set the objective function to maximize profit
model.setObjective(5*B + 7*R, GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*B + 15*R <= 2000, "Time_Constraint")
model.addConstr(B >= 3*R, "Ratio_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Beavers to make: {B.x}")
    print(f"Bears to make: {R.x}")
    print(f"Maximum Profit: {5*B.x + 7*R.x}")
else:
    print("No optimal solution found")

