
import gurobi

def solve_toy_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(name="beavers", lb=0, vtype=gurobi.GRB.INTEGER)
    R = model.addVar(name="bears", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(5 * B + 7 * R, gurobi.GRB.MAXIMIZE)

    # Production time constraint
    model.addConstr(10 * B + 15 * R <= 2000, name="production_time")

    # Beaver vs. bear production constraint
    model.addConstr(B >= 3 * R, name="beaver_bear_ratio")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Beavers = {B.varValue}, Bears = {R.varValue}")
        print(f"Max Profit: ${5 * B.varValue + 7 * R.varValue}")
    else:
        print("No optimal solution found")

solve_toy_production()
