
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x = m.addVar(lb=0, name="vaccine_investment")
y = m.addVar(lb=0, name="meat_replacement_investment")

# Set objective function
m.setObjective(0.05 * x + 0.07 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100000, "total_investment")
m.addConstr(y >= 0.6 * 100000, "meat_replacement_minimum")
m.addConstr(x <= 0.3 * 100000, "vaccine_maximum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in Vaccine Industry: ${x.x}")
    print(f"Optimal investment in Meat-Replacement Industry: ${y.x}")
    print(f"Optimal total return: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

