
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
x_v = m.addVar(name="vaccine_investment", lb=0)
x_m = m.addVar(name="meat_replacement_investment", lb=0)

# Add constraints
m.addConstr(x_v + x_m <= 100000, name="total_budget")
m.addConstr(x_m >= 60000, name="min_meat_replacement")
m.addConstr(x_v <= 30000, name="max_vaccine")

# Set the objective function
m.setObjective(0.05*x_v + 0.07*x_m, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
